/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.terminal.internal;

import com.aptana.terminal.IProcessConfiguration;
import com.aptana.terminal.internal.IProcessListener;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;

public class ProcessLauncher {
    private IProcessConfiguration configuration;
    private IPath initialDirectory;
    private Process process;
    private ListenerList processListeners = new ListenerList();

    public ProcessLauncher(IProcessConfiguration configuration, IPath initialDirectory) {
        this.configuration = configuration;
        this.initialDirectory = initialDirectory;
    }

    public void launch() throws IOException, CoreException {
        ProcessBuilder builder = new ProcessBuilder(this.configuration.getCommandLine());
        builder.environment().putAll(this.configuration.getEnvironment());
        builder.directory(this.initialDirectory != null ? this.initialDirectory.toFile() : null);
        this.process = builder.start();
        new Thread("Process watcher"){

            public void run() {
                try {
                    try {
                        ProcessLauncher.this.process.waitFor();
                    }
                    catch (InterruptedException ignore) {
                        ignore.getCause();
                        ProcessLauncher.this.notofyProcessCompleted();
                    }
                }
                finally {
                    ProcessLauncher.this.notofyProcessCompleted();
                }
            }
        }.start();
    }

    public void destroy() {
        if (this.process != null) {
            try {
                this.process.exitValue();
            }
            catch (IllegalThreadStateException e) {
                this.process.destroy();
            }
        }
    }

    public Process getProcess() {
        return this.process;
    }

    public void addProcessListener(IProcessListener listener) {
        this.processListeners.add((Object)listener);
    }

    public void removeProcessListener(IProcessListener listener) {
        this.processListeners.remove((Object)listener);
    }

    private void notofyProcessCompleted() {
        Object[] objectArray = this.processListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IProcessListener)listener).processCompleted();
            ++n2;
        }
    }
}

